%% History of transitions
% Martin H. Trauth 29 April 2021
clear, clc, close all

%%
dataraw = datastore('compilation_transitions_vs1.txt');
data = readall(dataraw);
data.Index = (1:size(data,1))';

data.Min = -data.Min;
data.Max = -data.Max;

%%
figure('Position',[100 200 800 500],...
    'Color',[1 1 1]);
axes('Units','Centimeters',...
    'Position',[3 3 22 12],...
    'LineWidth',1,...
    'FontSize',12,...
    'XLim',[-4 -1],...
    'YTick',[],...
    'YColor','none');
hold on
for i = 1 : size(data,1)
    if data.Region(i) == 1
        line([data.Min(i) data.Max(i)],...
        [data.Index(i) data.Index(i)],...
        'LineStyle','-',...
        'Marker','square',...
        'MarkerFaceColor',[0.1 0.5 0.8],...
        'LineWidth',1,...
        'Color',[0.1 0.5 0.8])
    elseif data.Region(i) == 2
        line([data.Min(i) data.Max(i)],...
        [data.Index(i) data.Index(i)],...
        'LineStyle','-',...
        'Marker','square',...
        'MarkerFaceColor',[0.8 0.5 0.1],...
        'LineWidth',1,...
        'Color',[0.8 0.5 0.1]) 
    elseif data.Region(i) == 3
        line([data.Min(i) data.Max(i)],...
        [data.Index(i) data.Index(i)],...
        'LineStyle','-',...
        'Marker','square',...
        'MarkerFaceColor',[0.5 0.8 0.1],...
        'LineWidth',1,...
        'Color',[0.5 0.8 0.1]) 
    end
end
text(data.Min+0.02,data.Index,...
        data.Authors)
hold off
xlabel('Time (Ma)')

print -dpng -r600 compilation_transitions_vs1.png

